/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.preferences;

import com.aptana.core.CoreStrings;
import com.aptana.core.resources.TaskTag;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.preferences.Messages;
import com.aptana.editor.common.preferences.TaskTagInputDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TasksPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DELIMITER = ",";
    private TableViewer fTasksTableViewer;
    private Button fCaseSensitiveButton;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        Label label = new Label(composite, 64);
        label.setText(Messages.TasksPreferencePage_Description);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.createTaskTableArea(composite);
        this.createCaseSensitiveArea(composite);
        this.updateButtonStates();
        return composite;
    }

    private void createCaseSensitiveArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.fCaseSensitiveButton = new Button(composite, 32);
        this.fCaseSensitiveButton.setFont(parent.getFont());
        this.fCaseSensitiveButton.setText(Messages.TasksPreferencePage_CaseSensitiveLabel);
        this.fCaseSensitiveButton.setSelection(this.getPreferenceStore().getBoolean("com.aptana.editor.common.taskTagsCaseSensitive"));
        this.setButtonLayoutData(this.fCaseSensitiveButton);
    }

    private void createTaskTableArea(Composite parent) {
        this.fTasksTableViewer = new TableViewer(parent, 2052);
        Table table = this.fTasksTableViewer.getTable();
        table.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        TableColumn tagNameColumn = new TableColumn(table, 0);
        tagNameColumn.setText(Messages.TasksPreferencePage_TagNameColumnHeader);
        tagNameColumn.setWidth(100);
        TableColumn tagPriorityColumn = new TableColumn(table, 0);
        tagPriorityColumn.setText(Messages.TasksPreferencePage_PriorityColumnHeader);
        tagPriorityColumn.setWidth(100);
        this.fTasksTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fTasksTableViewer.setLabelProvider((IBaseLabelProvider)new TaskLabelProvider());
        this.fTasksTableViewer.setComparator(new ViewerComparator());
        this.fTasksTableViewer.setInput(this.getTaskTags());
        this.fTasksTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TasksPreferencePage.this.updateButtonStates();
            }
        });
        this.createTaskButtons(parent);
    }

    private void createTaskButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.fAddButton = new Button(composite, 8);
        this.fAddButton.setText(StringUtil.ellipsify((String)CoreStrings.NEW));
        this.fAddButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).hint(Math.max(this.fAddButton.computeSize((int)-1, (int)-1, (boolean)true).x, this.convertHorizontalDLUsToPixels(61)), -1).create());
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TaskTag tag = new TaskTag("", 1);
                ArrayList<TaskTag> tags = new ArrayList<TaskTag>();
                TableItem[] tableItemArray = items = TasksPreferencePage.this.fTasksTableViewer.getTable().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem anItem = tableItemArray[n2];
                    tags.add((TaskTag)anItem.getData());
                    ++n2;
                }
                TaskTagInputDialog dialog = new TaskTagInputDialog(tag, tags, TasksPreferencePage.this.getShell());
                dialog.setTitle(Messages.TasksPreferencePage_NewTagTitle);
                if (dialog.open() == 0) {
                    tags.add(dialog.getTaskTag());
                    TasksPreferencePage.this.fTasksTableViewer.setInput(tags);
                }
            }
        });
        this.fEditButton = new Button(composite, 8);
        this.fEditButton.setText(StringUtil.ellipsify((String)CoreStrings.EDIT));
        this.fEditButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).hint(Math.max(this.fEditButton.computeSize((int)-1, (int)-1, (boolean)true).x, this.convertHorizontalDLUsToPixels(61)), -1).create());
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                ArrayList<TaskTag> tags = new ArrayList<TaskTag>();
                TableItem[] tableItemArray = items = TasksPreferencePage.this.fTasksTableViewer.getTable().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem anItem = tableItemArray[n2];
                    tags.add((TaskTag)anItem.getData());
                    ++n2;
                }
                int index = TasksPreferencePage.this.fTasksTableViewer.getTable().getSelectionIndex();
                TableItem item = TasksPreferencePage.this.fTasksTableViewer.getTable().getItem(index);
                TaskTag tag = (TaskTag)item.getData();
                ArrayList<TaskTag> copy = new ArrayList<TaskTag>(tags);
                copy.remove(index);
                TaskTagInputDialog dialog = new TaskTagInputDialog(tag, copy, TasksPreferencePage.this.getShell());
                dialog.setTitle(Messages.TasksPreferencePage_EditTagTitle);
                if (dialog.open() == 0) {
                    tags.set(index, dialog.getTaskTag());
                    TasksPreferencePage.this.fTasksTableViewer.setInput(tags);
                }
            }
        });
        this.fRemoveButton = new Button(composite, 8);
        this.fRemoveButton.setText(CoreStrings.REMOVE);
        this.fRemoveButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).hint(Math.max(this.fRemoveButton.computeSize((int)-1, (int)-1, (boolean)true).x, this.convertHorizontalDLUsToPixels(61)), -1).create());
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = TasksPreferencePage.this.fTasksTableViewer.getTable().getSelectionIndex();
                TasksPreferencePage.this.fTasksTableViewer.getTable().remove(index);
            }
        });
    }

    private List<TaskTag> getTaskTags() {
        String rawTagNames = this.getPreferenceStore().getString("com.aptana.editor.common.taskTagNames");
        String rawTagPriorities = this.getPreferenceStore().getString("com.aptana.editor.common.taskTagPriorities");
        return this.createTaskTags(rawTagNames, rawTagPriorities);
    }

    private void updateButtonStates() {
        boolean enable = !this.fTasksTableViewer.getSelection().isEmpty();
        this.fEditButton.setEnabled(enable);
        this.fRemoveButton.setEnabled(enable);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CommonEditorPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        TableItem[] items;
        ArrayList<String> tagNames = new ArrayList<String>();
        ArrayList<String> tagPriorities = new ArrayList<String>();
        TableItem[] tableItemArray = items = this.fTasksTableViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            TaskTag tag = (TaskTag)item.getData();
            tagNames.add(tag.getName());
            tagPriorities.add(tag.getPriorityName());
            ++n2;
        }
        this.getPreferenceStore().setValue("com.aptana.editor.common.taskTagNames", StringUtil.join((String)DELIMITER, (String[])tagNames.toArray(new String[tagNames.size()])));
        this.getPreferenceStore().setValue("com.aptana.editor.common.taskTagPriorities", StringUtil.join((String)DELIMITER, (String[])tagPriorities.toArray(new String[tagPriorities.size()])));
        this.getPreferenceStore().setValue("com.aptana.editor.common.taskTagsCaseSensitive", this.fCaseSensitiveButton.getSelection());
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        String rawTagNames = this.getPreferenceStore().getDefaultString("com.aptana.editor.common.taskTagNames");
        String rawTagPriorities = this.getPreferenceStore().getDefaultString("com.aptana.editor.common.taskTagPriorities");
        List<TaskTag> tags = this.createTaskTags(rawTagNames, rawTagPriorities);
        this.fTasksTableViewer.setInput(tags);
        this.fCaseSensitiveButton.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.editor.common.taskTagsCaseSensitive"));
    }

    private List<TaskTag> createTaskTags(String rawTagNames, String rawTagPriorities) {
        ArrayList<TaskTag> tags = new ArrayList<TaskTag>();
        String[] tagNames = rawTagNames.split(DELIMITER);
        String[] tagPriorities = rawTagPriorities.split(DELIMITER);
        int i = 0;
        while (i < tagNames.length) {
            tags.add(new TaskTag(tagNames[i], tagPriorities[i]));
            ++i;
        }
        return tags;
    }

    private static class TaskLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TaskLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TaskTag tag = (TaskTag)element;
            switch (columnIndex) {
                case 0: {
                    return tag.getName();
                }
                case 1: {
                    return tag.getPriorityName();
                }
            }
            return null;
        }
    }
}

